/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.DoubleBits;

public class Key {
    private Coordinate pt = new Coordinate();
    private int level = 0;
    private Envelope env = null;

    public static int computeQuadLevel(Envelope envelope) {
        double d;
        double d2 = envelope.getWidth();
        double d3 = d2 > (d = envelope.getHeight()) ? d2 : d;
        int n = DoubleBits.exponent(d3) + 1;
        return n;
    }

    public Key(Envelope envelope) {
        this.computeKey(envelope);
    }

    public Coordinate getPoint() {
        return this.pt;
    }

    public int getLevel() {
        return this.level;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    public Coordinate getCentre() {
        return new Coordinate((this.env.getMinX() + this.env.getMaxX()) / 2.0, (this.env.getMinY() + this.env.getMaxY()) / 2.0);
    }

    public void computeKey(Envelope envelope) {
        this.level = Key.computeQuadLevel(envelope);
        this.env = new Envelope();
        this.computeKey(this.level, envelope);
        while (!this.env.contains(envelope)) {
            ++this.level;
            this.computeKey(this.level, envelope);
        }
    }

    private void computeKey(int n, Envelope envelope) {
        double d = DoubleBits.powerOf2(n);
        this.pt.x = Math.floor(envelope.getMinX() / d) * d;
        this.pt.y = Math.floor(envelope.getMinY() / d) * d;
        this.env.init(this.pt.x, this.pt.x + d, this.pt.y, this.pt.y + d);
    }
}

