/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.MinimumDiameter;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Position;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OffsetCurveSetBuilder {
    private CGAlgorithms cga = new RobustCGAlgorithms();
    private Geometry inputGeom;
    private double distance;
    private OffsetCurveBuilder curveBuilder;
    private List curveList = new ArrayList();

    public OffsetCurveSetBuilder(Geometry geometry, double d, OffsetCurveBuilder offsetCurveBuilder) {
        this.inputGeom = geometry;
        this.distance = d;
        this.curveBuilder = offsetCurveBuilder;
    }

    public List getCurves() {
        this.add(this.inputGeom);
        return this.curveList;
    }

    private void addCurves(List list, int n, int n2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Coordinate[] coordinateArray = (Coordinate[])iterator.next();
            this.addCurve(coordinateArray, n, n2);
        }
    }

    private void addCurve(Coordinate[] coordinateArray, int n, int n2) {
        if (coordinateArray.length < 2) {
            return;
        }
        SegmentString segmentString = new SegmentString(coordinateArray, new Label(0, 1, n, n2));
        this.curveList.add(segmentString);
    }

    private void add(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof Polygon) {
            this.addPolygon((Polygon)geometry);
        } else if (geometry instanceof LineString) {
            this.addLineString((LineString)geometry);
        } else if (geometry instanceof Point) {
            this.addPoint((Point)geometry);
        } else if (geometry instanceof MultiPoint) {
            this.addCollection((MultiPoint)geometry);
        } else if (geometry instanceof MultiLineString) {
            this.addCollection((MultiLineString)geometry);
        } else if (geometry instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)geometry);
        } else {
            throw new UnsupportedOperationException(geometry.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection geometryCollection) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            this.add(geometry);
        }
    }

    private void addPoint(Point point) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coordinateArray = point.getCoordinates();
        List list = this.curveBuilder.getLineCurve(coordinateArray, this.distance);
        this.addCurves(list, 2, 0);
    }

    private void addLineString(LineString lineString) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(lineString.getCoordinates());
        List list = this.curveBuilder.getLineCurve(coordinateArray, this.distance);
        this.addCurves(list, 2, 0);
    }

    private void addPolygon(Polygon polygon) {
        double d = this.distance;
        int n = 1;
        if (this.distance < 0.0) {
            d = -this.distance;
            n = 2;
        }
        LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(linearRing.getCoordinates());
        if (this.distance < 0.0 && this.isErodedCompletely(coordinateArray, this.distance)) {
            return;
        }
        this.addPolygonRing(coordinateArray, d, n, 2, 0);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing linearRing2 = (LinearRing)polygon.getInteriorRingN(i);
            Coordinate[] coordinateArray2 = CoordinateArrays.removeRepeatedPoints(linearRing2.getCoordinates());
            if (this.distance > 0.0 && this.isErodedCompletely(coordinateArray2, -this.distance)) {
                return;
            }
            this.addPolygonRing(coordinateArray2, d, Position.opposite(n), 0, 2);
        }
    }

    private void addPolygonRing(Coordinate[] coordinateArray, double d, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (CGAlgorithms.isCCW(coordinateArray)) {
            n4 = n3;
            n5 = n2;
            n = Position.opposite(n);
        }
        List list = this.curveBuilder.getRingCurve(coordinateArray, n, d);
        this.addCurves(list, n4, n5);
    }

    private boolean isErodedCompletely(Coordinate[] coordinateArray, double d) {
        double d2 = 0.0;
        if (coordinateArray.length < 4) {
            return d < 0.0;
        }
        if (coordinateArray.length == 4) {
            return this.isTriangleErodedCompletely(coordinateArray, d);
        }
        LinearRing linearRing = this.inputGeom.getFactory().createLinearRing(coordinateArray);
        MinimumDiameter minimumDiameter = new MinimumDiameter(linearRing);
        d2 = minimumDiameter.getLength();
        return d2 < 2.0 * Math.abs(d);
    }

    private boolean isTriangleErodedCompletely(Coordinate[] coordinateArray, double d) {
        Triangle triangle = new Triangle(coordinateArray[0], coordinateArray[1], coordinateArray[2]);
        Coordinate coordinate = triangle.inCentre();
        double d2 = CGAlgorithms.distancePointLine(coordinate, triangle.p0, triangle.p1);
        return d2 < Math.abs(d);
    }
}

