/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeDirectedEdge;
import com.vividsolutions.jts.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.DirectedEdgeStar;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class PolygonizeGraph
extends PlanarGraph {
    private GeometryFactory factory;

    private static int getDegreeNonDeleted(Node node) {
        List list = node.getOutEdges().getEdges();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            if (polygonizeDirectedEdge.isMarked()) continue;
            ++n;
        }
        return n;
    }

    private static int getDegree(Node node, long l) {
        List list = node.getOutEdges().getEdges();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            if (polygonizeDirectedEdge.getLabel() != l) continue;
            ++n;
        }
        return n;
    }

    public static void deleteAllEdges(Node node) {
        List list = node.getOutEdges().getEdges();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            polygonizeDirectedEdge.setMarked(true);
            PolygonizeDirectedEdge polygonizeDirectedEdge2 = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
            if (polygonizeDirectedEdge2 == null) continue;
            polygonizeDirectedEdge2.setMarked(true);
        }
    }

    public PolygonizeGraph(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    public void addEdge(LineString lineString) {
        if (lineString.isEmpty()) {
            return;
        }
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(lineString.getCoordinates());
        Coordinate coordinate = coordinateArray[0];
        Coordinate coordinate2 = coordinateArray[coordinateArray.length - 1];
        Node node = this.getNode(coordinate);
        Node node2 = this.getNode(coordinate2);
        PolygonizeDirectedEdge polygonizeDirectedEdge = new PolygonizeDirectedEdge(node, node2, coordinateArray[1], true);
        PolygonizeDirectedEdge polygonizeDirectedEdge2 = new PolygonizeDirectedEdge(node2, node, coordinateArray[coordinateArray.length - 2], false);
        PolygonizeEdge polygonizeEdge = new PolygonizeEdge(lineString);
        polygonizeEdge.setDirectedEdges(polygonizeDirectedEdge, polygonizeDirectedEdge2);
        this.add(polygonizeEdge);
    }

    private Node getNode(Coordinate coordinate) {
        Node node = this.findNode(coordinate);
        if (node == null) {
            node = new Node(coordinate);
            this.add(node);
        }
        return node;
    }

    private void computeNextCWEdges() {
        Iterator iterator = this.nodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            PolygonizeGraph.computeNextCWEdges(node);
        }
    }

    private void convertMaximalToMinimalEdgeRings(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            long l;
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            List list2 = PolygonizeGraph.findIntersectionNodes(polygonizeDirectedEdge, l = polygonizeDirectedEdge.getLabel());
            if (list2 == null) continue;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator2.next();
                PolygonizeGraph.computeNextCCWEdges(node, l);
            }
        }
    }

    private static List findIntersectionNodes(PolygonizeDirectedEdge polygonizeDirectedEdge, long l) {
        PolygonizeDirectedEdge polygonizeDirectedEdge2 = polygonizeDirectedEdge;
        ArrayList<Node> arrayList = null;
        do {
            Node node;
            if (PolygonizeGraph.getDegree(node = polygonizeDirectedEdge2.getFromNode(), l) > 1) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>();
                }
                arrayList.add(node);
            }
            Assert.isTrue((polygonizeDirectedEdge2 = polygonizeDirectedEdge2.getNext()) != null, "found null DE in ring");
            Assert.isTrue(polygonizeDirectedEdge2 == polygonizeDirectedEdge || !polygonizeDirectedEdge2.isInRing(), "found DE already in ring");
        } while (polygonizeDirectedEdge2 != polygonizeDirectedEdge);
        return arrayList;
    }

    public List getEdgeRings() {
        this.computeNextCWEdges();
        PolygonizeGraph.label(this.dirEdges, -1L);
        List list = PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        this.convertMaximalToMinimalEdgeRings(list);
        ArrayList<EdgeRing> arrayList = new ArrayList<EdgeRing>();
        Iterator iterator = this.dirEdges.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            if (polygonizeDirectedEdge.isMarked() || polygonizeDirectedEdge.isInRing()) continue;
            EdgeRing edgeRing = this.findEdgeRing(polygonizeDirectedEdge);
            arrayList.add(edgeRing);
        }
        return arrayList;
    }

    private static List findLabeledEdgeRings(List list) {
        ArrayList<PolygonizeDirectedEdge> arrayList = new ArrayList<PolygonizeDirectedEdge>();
        long l = 1L;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            if (polygonizeDirectedEdge.isMarked() || polygonizeDirectedEdge.getLabel() >= 0L) continue;
            arrayList.add(polygonizeDirectedEdge);
            List list2 = PolygonizeGraph.findDirEdgesInRing(polygonizeDirectedEdge);
            PolygonizeGraph.label(list2, l);
            ++l;
        }
        return arrayList;
    }

    public List deleteCutEdges() {
        this.computeNextCWEdges();
        PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        Iterator iterator = this.dirEdges.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            if (polygonizeDirectedEdge.isMarked()) continue;
            PolygonizeDirectedEdge polygonizeDirectedEdge2 = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
            if (polygonizeDirectedEdge.getLabel() != polygonizeDirectedEdge2.getLabel()) continue;
            polygonizeDirectedEdge.setMarked(true);
            polygonizeDirectedEdge2.setMarked(true);
            PolygonizeEdge polygonizeEdge = (PolygonizeEdge)polygonizeDirectedEdge.getEdge();
            arrayList.add(polygonizeEdge.getLine());
        }
        return arrayList;
    }

    private static void label(List list, long l) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
            polygonizeDirectedEdge.setLabel(l);
        }
    }

    private static void computeNextCWEdges(Node node) {
        DirectedEdgeStar directedEdgeStar = node.getOutEdges();
        PolygonizeDirectedEdge polygonizeDirectedEdge = null;
        DirectedEdge directedEdge = null;
        Object object = directedEdgeStar.getEdges().iterator();
        while (object.hasNext()) {
            PolygonizeDirectedEdge polygonizeDirectedEdge2 = (PolygonizeDirectedEdge)object.next();
            if (polygonizeDirectedEdge2.isMarked()) continue;
            if (polygonizeDirectedEdge == null) {
                polygonizeDirectedEdge = polygonizeDirectedEdge2;
            }
            if (directedEdge != null) {
                PolygonizeDirectedEdge polygonizeDirectedEdge3 = (PolygonizeDirectedEdge)directedEdge.getSym();
                polygonizeDirectedEdge3.setNext(polygonizeDirectedEdge2);
            }
            directedEdge = polygonizeDirectedEdge2;
        }
        if (directedEdge != null) {
            object = (PolygonizeDirectedEdge)directedEdge.getSym();
            ((PolygonizeDirectedEdge)object).setNext(polygonizeDirectedEdge);
        }
    }

    private static void computeNextCCWEdges(Node node, long l) {
        DirectedEdgeStar directedEdgeStar = node.getOutEdges();
        PolygonizeDirectedEdge polygonizeDirectedEdge = null;
        PolygonizeDirectedEdge polygonizeDirectedEdge2 = null;
        List list = directedEdgeStar.getEdges();
        for (int i = list.size() - 1; i >= 0; --i) {
            PolygonizeDirectedEdge polygonizeDirectedEdge3 = (PolygonizeDirectedEdge)list.get(i);
            PolygonizeDirectedEdge polygonizeDirectedEdge4 = (PolygonizeDirectedEdge)polygonizeDirectedEdge3.getSym();
            PolygonizeDirectedEdge polygonizeDirectedEdge5 = null;
            if (polygonizeDirectedEdge3.getLabel() == l) {
                polygonizeDirectedEdge5 = polygonizeDirectedEdge3;
            }
            PolygonizeDirectedEdge polygonizeDirectedEdge6 = null;
            if (polygonizeDirectedEdge4.getLabel() == l) {
                polygonizeDirectedEdge6 = polygonizeDirectedEdge4;
            }
            if (polygonizeDirectedEdge5 == null && polygonizeDirectedEdge6 == null) continue;
            if (polygonizeDirectedEdge6 != null) {
                polygonizeDirectedEdge2 = polygonizeDirectedEdge6;
            }
            if (polygonizeDirectedEdge5 == null) continue;
            if (polygonizeDirectedEdge2 != null) {
                polygonizeDirectedEdge2.setNext(polygonizeDirectedEdge5);
                polygonizeDirectedEdge2 = null;
            }
            if (polygonizeDirectedEdge != null) continue;
            polygonizeDirectedEdge = polygonizeDirectedEdge5;
        }
        if (polygonizeDirectedEdge2 != null) {
            Assert.isTrue(polygonizeDirectedEdge != null);
            polygonizeDirectedEdge2.setNext(polygonizeDirectedEdge);
        }
    }

    private static List findDirEdgesInRing(PolygonizeDirectedEdge polygonizeDirectedEdge) {
        PolygonizeDirectedEdge polygonizeDirectedEdge2 = polygonizeDirectedEdge;
        ArrayList<PolygonizeDirectedEdge> arrayList = new ArrayList<PolygonizeDirectedEdge>();
        do {
            arrayList.add(polygonizeDirectedEdge2);
            polygonizeDirectedEdge2 = polygonizeDirectedEdge2.getNext();
            Assert.isTrue(polygonizeDirectedEdge2 != null, "found null DE in ring");
            Assert.isTrue(polygonizeDirectedEdge2 == polygonizeDirectedEdge || !polygonizeDirectedEdge2.isInRing(), "found DE already in ring");
        } while (polygonizeDirectedEdge2 != polygonizeDirectedEdge);
        return arrayList;
    }

    private EdgeRing findEdgeRing(PolygonizeDirectedEdge polygonizeDirectedEdge) {
        PolygonizeDirectedEdge polygonizeDirectedEdge2 = polygonizeDirectedEdge;
        EdgeRing edgeRing = new EdgeRing(this.factory);
        do {
            edgeRing.add(polygonizeDirectedEdge2);
            polygonizeDirectedEdge2.setRing(edgeRing);
            polygonizeDirectedEdge2 = polygonizeDirectedEdge2.getNext();
            Assert.isTrue(polygonizeDirectedEdge2 != null, "found null DE in ring");
            Assert.isTrue(polygonizeDirectedEdge2 == polygonizeDirectedEdge || !polygonizeDirectedEdge2.isInRing(), "found DE already in ring");
        } while (polygonizeDirectedEdge2 != polygonizeDirectedEdge);
        return edgeRing;
    }

    public Collection deleteDangles() {
        List list = this.findNodesOfDegree(1);
        HashSet<LineString> hashSet = new HashSet<LineString>();
        Stack stack = new Stack();
        Object object = list.iterator();
        while (object.hasNext()) {
            stack.push(object.next());
        }
        while (!stack.isEmpty()) {
            object = (Node)stack.pop();
            PolygonizeGraph.deleteAllEdges((Node)object);
            List list2 = ((Node)object).getOutEdges().getEdges();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                PolygonizeDirectedEdge polygonizeDirectedEdge = (PolygonizeDirectedEdge)iterator.next();
                polygonizeDirectedEdge.setMarked(true);
                PolygonizeDirectedEdge polygonizeDirectedEdge2 = (PolygonizeDirectedEdge)polygonizeDirectedEdge.getSym();
                if (polygonizeDirectedEdge2 != null) {
                    polygonizeDirectedEdge2.setMarked(true);
                }
                PolygonizeEdge polygonizeEdge = (PolygonizeEdge)polygonizeDirectedEdge.getEdge();
                hashSet.add(polygonizeEdge.getLine());
                Node node = polygonizeDirectedEdge.getToNode();
                if (PolygonizeGraph.getDegreeNonDeleted(node) != 1) continue;
                stack.push(node);
            }
        }
        return hashSet;
    }
}

