/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RepeatedPointTester {
    private Coordinate repeatedCoord;

    public Coordinate getCoordinate() {
        return this.repeatedCoord;
    }

    public boolean hasRepeatedPoint(Geometry geometry) {
        if (geometry.isEmpty()) {
            return false;
        }
        if (geometry instanceof Point) {
            return false;
        }
        if (geometry instanceof MultiPoint) {
            return false;
        }
        if (geometry instanceof LineString) {
            return this.hasRepeatedPoint(((LineString)geometry).getCoordinates());
        }
        if (geometry instanceof Polygon) {
            return this.hasRepeatedPoint((Polygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.hasRepeatedPoint((GeometryCollection)geometry);
        }
        throw new UnsupportedOperationException(geometry.getClass().getName());
    }

    public boolean hasRepeatedPoint(Coordinate[] coordinateArray) {
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (!coordinateArray[i - 1].equals(coordinateArray[i])) continue;
            this.repeatedCoord = coordinateArray[i];
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(Polygon polygon) {
        if (this.hasRepeatedPoint(polygon.getExteriorRing().getCoordinates())) {
            return true;
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            if (!this.hasRepeatedPoint(polygon.getInteriorRingN(i).getCoordinates())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(GeometryCollection geometryCollection) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            if (!this.hasRepeatedPoint(geometry)) continue;
            return true;
        }
        return false;
    }
}

