/* $Id: record.h,v 1.2 2005/12/01 00:38:47 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Python interface to the Postgres record type
 */
#ifndef PyPg_type_record_H
#define PyPg_type_record_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPg_record {
	PyPgObject_HEAD
	TupleDesc rec_td;
} * PyPg_record;

extern PyPgTypeObject PyPg_record_Type;
IF_PGTYPE_ATTRIBUTE(extern PyPgTypeObject PyPg_attribute_Type;)

PyObj PyPg_record_Initialize(PyObj, HeapTupleHeader *);
PyObj PyPg_record_Type_FromTupleDesc(TupleDesc);

#define PyPg_record_NEW() \
	(PyObj) PyPg_record_Type.tp_alloc(&PyPg_record_Type, 0)
#define PyPg_record_New(R) \
	PyPg_record_Initialize(PyPg_record_NEW(), R)

#define PyPg_record(SELF) ((PyPg_record) SELF)

#define PyPg_record_Check(SELF) \
	(PyObject_TypeCheck((PyObj) SELF, (PyTypeObject *) &PyPg_record_Type))
#define PyPg_record_CheckExact(SELF) (SELF->ob_type == &PyPg_record_Type)

#define PyPg_record_FetchHeapTupleHeader(SELF) \
	(DatumGetHeapTupleHeader(PyPgObject_FetchDatum(SELF)))

#define PyPg_record_FixHeapTupleHeader(SELF, R) \
	PyPgObject_FixDatum(SELF, PointerGetDatum(R))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_record_H */
/*
 * vim: ts=3:sw=3:noet:
 */
