--
-- PostgreSQL database dump
--

/*
PLEASE change dbowner to whomever owns your database or this will not work.
If you have correct DB permissions, you might want to edit the bit at the bottom
commented out.

This is a Tracker Beta4 dump and contains significant changes! Please see
file entitled "CHANGELOG."
*/

\connect tracker

SET client_encoding = 'UNICODE';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;

--
-- Name: customers; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE customers (
    customer_id serial NOT NULL,
    first_name character varying NOT NULL,
    last_name character varying NOT NULL,
    email character varying,
    status integer,
    added timestamp(0) without time zone DEFAULT now() NOT NULL,
    state character varying NOT NULL,
    city character varying NOT NULL,
    zip character varying NOT NULL,
    street1 character varying NOT NULL,
    phone1 character varying NOT NULL,
    street2 character varying,
    phone2 character varying,
    notes text,
    country character varying NOT NULL
);


ALTER TABLE public.customers OWNER TO dbowner;

--
-- Name: customers_customer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('customers', 'customer_id'), 0, true);


--
-- Name: customers_id_seq; Type: SEQUENCE; Schema: public; Owner: dbowner
--

CREATE SEQUENCE customers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.customers_id_seq OWNER TO dbowner;

--
-- Name: customers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval('customers_id_seq', 0, false);


SET default_with_oids = true;

--
-- Name: links; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE links (
    id serial NOT NULL,
    href character varying NOT NULL,
    description character varying NOT NULL,
    category integer DEFAULT 0 NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    "security" integer DEFAULT 0 NOT NULL,
    visible smallint DEFAULT 0 NOT NULL,
    token character varying NOT NULL
);


ALTER TABLE public.links OWNER TO dbowner;

--
-- Name: links_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('links', 'id'), 10, true);


--
-- Name: notes; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE notes (
    note_id serial NOT NULL,
    work_order_id integer NOT NULL,
    author character varying,
    date timestamp(0) without time zone DEFAULT now(),
    text text
);


ALTER TABLE public.notes OWNER TO dbowner;

--
-- Name: note_note_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('notes', 'note_id'), 0, true);


--
-- Name: problems; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE problems (
    problem_id serial NOT NULL,
    work_order_id integer NOT NULL,
    cost double precision,
    description text NOT NULL,
    notes text,
    estimated_time double precision,
    actual_time double precision
);


ALTER TABLE public.problems OWNER TO dbowner;

--
-- Name: problem_problem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('problems', 'problem_id'), 0, true);


SET default_with_oids = false;

--
-- Name: users; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE users (
    username character varying NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    acct_type bigint DEFAULT 1 NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    pass character varying
);


ALTER TABLE public.users OWNER TO dbowner;

SET default_with_oids = true;

--
-- Name: workorders; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE workorders (
    workorder_id serial NOT NULL,
    customer_id integer NOT NULL,
    start_date timestamp(0) without time zone NOT NULL,
    promised_date timestamp(0) without time zone NOT NULL,
    status integer NOT NULL,
    total_cost double precision,
    description text,
    staff character varying
);


ALTER TABLE public.workorders OWNER TO dbowner;

--
-- Name: workorder_cust; Type: VIEW; Schema: public; Owner: dbowner
--

CREATE VIEW workorder_cust AS
    SELECT workorders.start_date, workorders.promised_date, workorders.workorder_id, workorders.staff, workorders.status AS wo_status, customers.customer_id, customers.first_name, customers.last_name, customers.email, customers.status, customers.added, customers.state, customers.city, customers.zip, customers.street1, customers.phone1, customers.street2, customers.phone2, customers.notes, customers.country FROM workorders, customers WHERE (customers.customer_id = workorders.customer_id) ORDER BY workorders.status, workorders.promised_date;


ALTER TABLE public.workorder_cust OWNER TO dbowner;

--
-- Name: workorder_workorder_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('workorders', 'workorder_id'), 0, true);

--
-- Data for Name: links; Type: TABLE DATA; Schema: public; Owner: dbowner
--

INSERT INTO links VALUES (8, 'invoice_detail.php', 'invoice detail', 0, 0, 0, 0, 'wo_detail');
INSERT INTO links VALUES (2, 'add_customer.php', 'New Customer', 0, 0, 0, 1, 'add_customer');
INSERT INTO links VALUES (3, 'add_workorder.php', 'New Ticket', 0, 0, 0, 1, 'add_wo');
INSERT INTO links VALUES (4, 'add_problem.php', 'Add problem to ticket', 0, 0, 0, 1, 'add_problem');
INSERT INTO links VALUES (5, 'add_note.php', 'Write Note', 0, 0, 0, 1, 'add_note');
INSERT INTO links VALUES (6, 'open_workorders.php', 'Tickets', 0, 0, 0, 1, 'open_wo');
INSERT INTO links VALUES (7, 'index.php?exit=1', 'Exit', 0, 0, 0, 1, 'quit');
INSERT INTO links VALUES (1, 'index.php', 'Home', 0, 0, 0, 1, 'menu');
INSERT INTO links VALUES (9, 'problem_detail.php', 'Detail IFrame for problem on invoice', 0, 0, 0, 0, 'problem_detail');
INSERT INTO links VALUES (10, 'note_detail.php', 'Detail IFrame for note on invoice', 0, 0, 0, 0, 'note_detail');

--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: dbowner
--

INSERT INTO users VALUES ('admin', 1, 2, '2005-05-23 06:36:02.812', '098f6bcd4621d373cade4e832627b4f6');

--
-- Name: customers_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY customers
    ADD CONSTRAINT customers_pkey PRIMARY KEY (customer_id);


ALTER INDEX public.customers_pkey OWNER TO dbowner;

--
-- Name: problem_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY problems
    ADD CONSTRAINT problem_pkey PRIMARY KEY (problem_id);


ALTER INDEX public.problem_pkey OWNER TO dbowner;

--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (username);


ALTER INDEX public.users_pkey OWNER TO dbowner;

--
-- Name: workorder_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY workorders
    ADD CONSTRAINT workorder_pkey PRIMARY KEY (workorder_id);


ALTER INDEX public.workorder_pkey OWNER TO dbowner;

--
-- Name: problem_added; Type: RULE; Schema: public; Owner: dbowner
--

CREATE RULE problem_added AS ON INSERT TO problems DO UPDATE workorders SET total_cost = (workorder.total_cost + new.cost) WHERE (workorder.workorder_id = new.work_order_id);


--
-- Name: RULE problem_added ON problems; Type: COMMENT; Schema: public; Owner: dbowner
--

COMMENT ON RULE problem_added ON problems IS 'add problem''s cost to workorder total cost';


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: dbowner
--

ALTER TABLE ONLY problems
    ADD CONSTRAINT "$1" FOREIGN KEY (work_order_id) REFERENCES workorders(workorder_id) ON UPDATE CASCADE ON DELETE CASCADE;

/*
--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: customers; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE customers FROM PUBLIC;
REVOKE ALL ON TABLE customers FROM dbowner;
GRANT ALL ON TABLE customers TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE customers TO PUBLIC;


--
-- Name: notes; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE notes FROM PUBLIC;
REVOKE ALL ON TABLE notes FROM dbowner;
GRANT ALL ON TABLE notes TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE notes TO PUBLIC;


--
-- Name: note_note_id_seq; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE note_note_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE note_note_id_seq FROM dbowner;
GRANT ALL ON TABLE note_note_id_seq TO dbowner;
GRANT ALL ON TABLE note_note_id_seq TO PUBLIC;


--
-- Name: problems; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE problems FROM PUBLIC;
REVOKE ALL ON TABLE problems FROM dbowner;
GRANT ALL ON TABLE problems TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE problems TO PUBLIC;


--
-- Name: problem_problem_id_seq; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE problem_problem_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE problem_problem_id_seq FROM dbowner;
GRANT ALL ON TABLE problem_problem_id_seq TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE problem_problem_id_seq TO PUBLIC;


--
-- Name: workorders; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE workorders FROM PUBLIC;
REVOKE ALL ON TABLE workorders FROM dbowner;
GRANT ALL ON TABLE workorders TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE workorders TO PUBLIC;


--
-- Name: workorder_workorder_id_seq; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE workorder_workorder_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE workorder_workorder_id_seq FROM dbowner;
GRANT ALL ON TABLE workorder_workorder_id_seq TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE workorder_workorder_id_seq TO PUBLIC;


--
-- PostgreSQL database dump complete
--*/
